# -*- coding: utf-8 -*-

# Form implementation generated from reading ui file 'mainwindow.ui'
#
# Created by: PyQt5 UI code generator 5.13.0
#
# WARNING! All changes made in this file will be lost!

# # # python scripts
import sys
from PyQt5 import QtCore, QtGui, QtWidgets
from PyQt5.QtWidgets import *
from PyQt5.QtCore import *
import matplotlib.pyplot as plt
from matplotlib.backends.backend_qt5agg import FigureCanvasQTAgg as FigureCanvas
import serial.tools.list_ports
from queue import Queue
import threading
import time

# # # private scripts
import anchor_common
import CalcPosition
import serial_rw

# # # public variable
baudRate = 115200
ser = []
portlist = []
portlist_str = []
thread1 = []
list_myanchors = list()
my_queue = Queue()
my_queue.empty()
first_get_location = True

# just for test
testx = float(5.0)
testy = float(5.0)
global my_output_file


class RSSI_Test_MainWindow(object):
    def __init__(self):
        global fig_ax1
        self.isLocatingStart = False
        self._thread_running = False

    def setupUi(self, MainWindow):
        MainWindow.setObjectName("MainWindow")
        MainWindow.resize(955, 908)
        MainWindow.setLayoutDirection(QtCore.Qt.LeftToRight)
        self.centralwidget = QtWidgets.QWidget(MainWindow)
        self.centralwidget.setObjectName("centralwidget")
        self.layoutWidget = QtWidgets.QWidget(self.centralwidget)
        self.layoutWidget.setGeometry(QtCore.QRect(10, 40, 211, 741))
        self.layoutWidget.setObjectName("layoutWidget")
        self.verticalLayout_3 = QtWidgets.QVBoxLayout(self.layoutWidget)
        self.verticalLayout_3.setContentsMargins(0, 0, 0, 0)
        self.verticalLayout_3.setSpacing(7)
        self.verticalLayout_3.setObjectName("verticalLayout_3")
        self.groupBox = QtWidgets.QGroupBox(self.layoutWidget)
        self.groupBox.setObjectName("groupBox")
        self.groupBox_2 = QtWidgets.QGroupBox(self.groupBox)
        self.groupBox_2.setGeometry(QtCore.QRect(10, 120, 181, 61))
        self.groupBox_2.setObjectName("groupBox_2")
        self.label_X1 = QtWidgets.QLabel(self.groupBox_2)
        self.label_X1.setGeometry(QtCore.QRect(10, 20, 21, 21))
        self.label_X1.setObjectName("label_X1")
        self.lineEdit_X1 = QtWidgets.QLineEdit(self.groupBox_2)
        self.lineEdit_X1.setGeometry(QtCore.QRect(30, 20, 51, 22))
        self.lineEdit_X1.setObjectName("lineEdit_X1")
        self.lineEdit_X1.setValidator(QtGui.QDoubleValidator())
        self.label_Y1 = QtWidgets.QLabel(self.groupBox_2)
        self.label_Y1.setGeometry(QtCore.QRect(100, 20, 21, 21))
        self.label_Y1.setObjectName("label_Y1")
        self.lineEdit_Y1 = QtWidgets.QLineEdit(self.groupBox_2)
        self.lineEdit_Y1.setGeometry(QtCore.QRect(120, 20, 51, 22))
        self.lineEdit_Y1.setObjectName("lineEdit_Y1")
        self.lineEdit_Y1.setValidator(QtGui.QDoubleValidator())
        # jia redefine combo box show popup function
        self.comboBox_anchor1 = CustomComboBox(self.groupBox)
        self.comboBox_anchor1.setGeometry(QtCore.QRect(102, 30, 81, 22))
        self.comboBox_anchor1.setObjectName("comboBox_anchor1")
        self.label_1 = QtWidgets.QLabel(self.groupBox)
        self.label_1.setGeometry(QtCore.QRect(20, 30, 55, 16))
        self.label_1.setObjectName("label_1")
        self.label_2 = QtWidgets.QLabel(self.groupBox)
        self.label_2.setGeometry(QtCore.QRect(20, 80, 71, 16))
        self.label_2.setObjectName("label_2")
        self.lineEdit_5 = QtWidgets.QLineEdit(self.groupBox)
        self.lineEdit_5.setGeometry(QtCore.QRect(100, 80, 81, 22))
        self.lineEdit_5.setObjectName("lineEdit_5")
        self.lineEdit_5.setText("0.0")
        # Limit the data that enter to lineEdit with Regular expression Validator
        #__regExp = QtCore.QRegExp('^(-(([0-9]+\.[0-9]*[1-9][0-9]*)|([0-9]*[1-9][0-9]*\.[0-9]+)|([0-9]*[1-9][0-9]*)))$')
        #self.lineEdit_5.setValidator(QtGui.QRegExpValidator(__regExp, MainWindow))
        self.lineEdit_5.setValidator(QtGui.QDoubleValidator())
        self.verticalLayout_3.addWidget(self.groupBox)
        self.groupBox_3 = QtWidgets.QGroupBox(self.layoutWidget)
        self.groupBox_3.setObjectName("groupBox_3")
        self.groupBox_5 = QtWidgets.QGroupBox(self.groupBox_3)
        self.groupBox_5.setGeometry(QtCore.QRect(10, 120, 181, 61))
        self.groupBox_5.setObjectName("groupBox_5")
        self.label_X2 = QtWidgets.QLabel(self.groupBox_5)
        self.label_X2.setGeometry(QtCore.QRect(10, 20, 21, 21))
        self.label_X2.setObjectName("label_X2")
        self.lineEdit_X2 = QtWidgets.QLineEdit(self.groupBox_5)
        self.lineEdit_X2.setGeometry(QtCore.QRect(30, 20, 51, 22))
        self.lineEdit_X2.setObjectName("lineEdit_X2")
        self.lineEdit_X2.setValidator(QtGui.QDoubleValidator())
        self.label_Y2 = QtWidgets.QLabel(self.groupBox_5)
        self.label_Y2.setGeometry(QtCore.QRect(100, 20, 21, 21))
        self.label_Y2.setObjectName("label_Y2")
        self.lineEdit_Y2 = QtWidgets.QLineEdit(self.groupBox_5)
        self.lineEdit_Y2.setGeometry(QtCore.QRect(120, 20, 51, 22))
        self.lineEdit_Y2.setObjectName("lineEdit_Y2")
        self.lineEdit_Y2.setValidator(QtGui.QDoubleValidator())
        # jia redefine combo box show popup function
        self.comboBox_anchor2 = CustomComboBox(self.groupBox_3)
        self.comboBox_anchor2.setGeometry(QtCore.QRect(102, 30, 81, 22))
        self.comboBox_anchor2.setObjectName("comboBox_anchor2")
        self.label_3 = QtWidgets.QLabel(self.groupBox_3)
        self.label_3.setGeometry(QtCore.QRect(20, 30, 55, 16))
        self.label_3.setObjectName("label_3")
        self.label_4 = QtWidgets.QLabel(self.groupBox_3)
        self.label_4.setGeometry(QtCore.QRect(20, 80, 71, 16))
        self.label_4.setObjectName("label_4")
        self.lineEdit_8 = QtWidgets.QLineEdit(self.groupBox_3)
        self.lineEdit_8.setGeometry(QtCore.QRect(100, 80, 81, 22))
        self.lineEdit_8.setObjectName("lineEdit_8")
        self.lineEdit_8.setText("0.0")
        self.lineEdit_8.setValidator(QtGui.QDoubleValidator())
        self.verticalLayout_3.addWidget(self.groupBox_3)
        self.groupBox_6 = QtWidgets.QGroupBox(self.layoutWidget)
        self.groupBox_6.setObjectName("groupBox_6")
        self.groupBox_7 = QtWidgets.QGroupBox(self.groupBox_6)
        self.groupBox_7.setGeometry(QtCore.QRect(10, 120, 181, 61))
        self.groupBox_7.setObjectName("groupBox_7")
        self.label_X3 = QtWidgets.QLabel(self.groupBox_7)
        self.label_X3.setGeometry(QtCore.QRect(10, 20, 21, 21))
        self.label_X3.setObjectName("label_X3")
        self.lineEdit_X3 = QtWidgets.QLineEdit(self.groupBox_7)
        self.lineEdit_X3.setGeometry(QtCore.QRect(30, 20, 51, 22))
        self.lineEdit_X3.setObjectName("lineEdit_X3")
        self.lineEdit_X3.setValidator(QtGui.QDoubleValidator())
        self.label_Y3 = QtWidgets.QLabel(self.groupBox_7)
        self.label_Y3.setGeometry(QtCore.QRect(100, 20, 21, 21))
        self.label_Y3.setObjectName("label_Y3")
        self.lineEdit_Y3 = QtWidgets.QLineEdit(self.groupBox_7)
        self.lineEdit_Y3.setGeometry(QtCore.QRect(120, 20, 51, 22))
        self.lineEdit_Y3.setObjectName("lineEdit_Y3")
        self.lineEdit_Y3.setValidator(QtGui.QDoubleValidator())
        # jia redefine combo box show popup function
        self.comboBox_anchor3 = CustomComboBox(self.groupBox_6)
        self.comboBox_anchor3.setGeometry(QtCore.QRect(102, 30, 81, 22))
        self.comboBox_anchor3.setObjectName("comboBox_anchor3")
        self.label_5 = QtWidgets.QLabel(self.groupBox_6)
        self.label_5.setGeometry(QtCore.QRect(20, 30, 55, 16))
        self.label_5.setObjectName("label_5")
        self.label_6 = QtWidgets.QLabel(self.groupBox_6)
        self.label_6.setGeometry(QtCore.QRect(20, 80, 71, 16))
        self.label_6.setObjectName("label_6")
        self.lineEdit_11 = QtWidgets.QLineEdit(self.groupBox_6)
        self.lineEdit_11.setGeometry(QtCore.QRect(100, 80, 81, 22))
        self.lineEdit_11.setObjectName("lineEdit_11")
        self.lineEdit_11.setText("0.0")
        self.lineEdit_11.setValidator(QtGui.QDoubleValidator())
        self.verticalLayout_3.addWidget(self.groupBox_6)
        self.groupBox_8 = QtWidgets.QGroupBox(self.layoutWidget)
        self.groupBox_8.setObjectName("groupBox_8")
        self.groupBox_9 = QtWidgets.QGroupBox(self.groupBox_8)
        self.groupBox_9.setGeometry(QtCore.QRect(10, 120, 181, 61))
        self.groupBox_9.setObjectName("groupBox_9")
        self.label_X4 = QtWidgets.QLabel(self.groupBox_9)
        self.label_X4.setGeometry(QtCore.QRect(10, 20, 21, 21))
        self.label_X4.setObjectName("label_X4")
        self.lineEdit_X4 = QtWidgets.QLineEdit(self.groupBox_9)
        self.lineEdit_X4.setGeometry(QtCore.QRect(30, 20, 51, 22))
        self.lineEdit_X4.setObjectName("lineEdit_X4")
        self.lineEdit_X4.setValidator(QtGui.QDoubleValidator())
        self.label_Y4 = QtWidgets.QLabel(self.groupBox_9)
        self.label_Y4.setGeometry(QtCore.QRect(100, 20, 21, 21))
        self.label_Y4.setObjectName("label_Y4")
        self.lineEdit_Y4 = QtWidgets.QLineEdit(self.groupBox_9)
        self.lineEdit_Y4.setGeometry(QtCore.QRect(120, 20, 51, 22))
        self.lineEdit_Y4.setObjectName("lineEdit_Y4")
        self.lineEdit_Y4.setValidator(QtGui.QDoubleValidator())
        # jia redefine combo box show popup function
        self.comboBox_anchor4 = CustomComboBox(self.groupBox_8)
        self.comboBox_anchor4.setGeometry(QtCore.QRect(102, 30, 81, 22))
        self.comboBox_anchor4.setObjectName("comboBox_anchor4")
        self.label_7 = QtWidgets.QLabel(self.groupBox_8)
        self.label_7.setGeometry(QtCore.QRect(20, 30, 55, 16))
        self.label_7.setObjectName("label_7")
        self.label_8 = QtWidgets.QLabel(self.groupBox_8)
        self.label_8.setGeometry(QtCore.QRect(20, 80, 71, 16))
        self.label_8.setObjectName("label_8")
        self.lineEdit_14 = QtWidgets.QLineEdit(self.groupBox_8)
        self.lineEdit_14.setGeometry(QtCore.QRect(100, 80, 81, 22))
        self.lineEdit_14.setObjectName("lineEdit_14")
        self.lineEdit_14.setText("0.0")
        self.lineEdit_14.setValidator(QtGui.QDoubleValidator())
        self.verticalLayout_3.addWidget(self.groupBox_8)
        self.layoutWidget1 = QtWidgets.QWidget(self.centralwidget)
        self.layoutWidget1.setGeometry(QtCore.QRect(10, 10, 211, 24))
        self.layoutWidget1.setObjectName("layoutWidget1")
        self.horizontalLayout = QtWidgets.QHBoxLayout(self.layoutWidget1)
        self.horizontalLayout.setContentsMargins(0, 0, 0, 0)
        self.horizontalLayout.setObjectName("horizontalLayout")
        self.label = QtWidgets.QLabel(self.layoutWidget1)
        self.label.setObjectName("label")
        self.horizontalLayout.addWidget(self.label)
        self.lineEdit_attenuation = QtWidgets.QLineEdit(self.layoutWidget1)
        self.lineEdit_attenuation.setObjectName("lineEdit_attenuation")
        self.lineEdit_attenuation.setText("3.25")
        self.horizontalLayout.addWidget(self.lineEdit_attenuation)
        self.layoutWidget2 = QtWidgets.QWidget(self.centralwidget)
        self.layoutWidget2.setGeometry(QtCore.QRect(10, 820, 211, 30))
        self.layoutWidget2.setObjectName("layoutWidget2")
        self.horizontalLayout_2 = QtWidgets.QHBoxLayout(self.layoutWidget2)
        self.horizontalLayout_2.setContentsMargins(0, 0, 0, 0)
        self.horizontalLayout_2.setObjectName("horizontalLayout_2")
        self.startButton = QtWidgets.QPushButton(self.layoutWidget2)
        self.startButton.setObjectName("startButton")
        self.horizontalLayout_2.addWidget(self.startButton)
        self.ExitButton = QtWidgets.QPushButton(self.layoutWidget2)
        self.ExitButton.setObjectName("ExitButton")
        self.horizontalLayout_2.addWidget(self.ExitButton)
        self.gridLayoutWidget = QtWidgets.QWidget(self.centralwidget)
        self.gridLayoutWidget.setGeometry(QtCore.QRect(230, 10, 1500, 1000))
        self.gridLayoutWidget.setObjectName("gridLayoutWidget")
        self.gridLayout = QtWidgets.QGridLayout(self.gridLayoutWidget)
        self.gridLayout.setContentsMargins(0, 0, 0, 0)
        self.gridLayout.setObjectName("gridLayout")
        self.checkBox = QtWidgets.QCheckBox(self.centralwidget)
        self.checkBox.setGeometry(QtCore.QRect(20, 790, 141, 20))
        self.checkBox.setObjectName("checkBox")
        # self.checkBox.setChecked(True)
        # add a blank figure to widget
        global fig_ax1
        global figure
        figure = plt.figure()
        fig_ax1 = figure.add_subplot(1, 1, 1)
        for label in fig_ax1.get_xticklabels():
            label.set_visible(False)
        fig_ax1.set_title("localization, unit is mm")
        # fig_ax1.margins(0)
        # fig_ax1.plot(1, 1, 'r*', color='g')

        canvas = FigureCanvas(figure)
        plt.ion()
        self.gridLayout.addWidget(canvas)

        # Set menu bar
        MainWindow.setCentralWidget(self.centralwidget)
        self.menubar = QtWidgets.QMenuBar(MainWindow)
        self.menubar.setGeometry(QtCore.QRect(0, 0, 955, 26))
        self.menubar.setObjectName("menubar")
        MainWindow.setMenuBar(self.menubar)
        self.statusbar = QtWidgets.QStatusBar(MainWindow)
        self.statusbar.setObjectName("statusbar")
        MainWindow.setStatusBar(self.statusbar)

        self.retranslateUi(MainWindow)

        self.serial_port_scan()

        # # #connect signal to slot
        self.comboBox_anchor1.popupAboutToBeShown.connect(self.slot_refresh_combo_box1)
        self.comboBox_anchor2.popupAboutToBeShown.connect(self.slot_refresh_combo_box2)
        self.comboBox_anchor3.popupAboutToBeShown.connect(self.slot_refresh_combo_box3)
        self.comboBox_anchor4.popupAboutToBeShown.connect(self.slot_refresh_combo_box4)
        self.startButton.clicked.connect(self.slot_start_stop_localization)
        self.ExitButton.clicked.connect(MainWindow.close)
        # # #
        QtCore.QMetaObject.connectSlotsByName(MainWindow)


    def retranslateUi(self, MainWindow):
        _translate = QtCore.QCoreApplication.translate
        MainWindow.setWindowTitle(_translate("MainWindow", "MainWindow"))
        self.groupBox.setTitle(_translate("MainWindow", "ANCHOR1"))
        self.groupBox_2.setTitle(_translate("MainWindow", "coordinate"))
        self.label_X1.setText(_translate("MainWindow", "X1"))
        self.label_Y1.setText(_translate("MainWindow", "Y1"))
        self.label_1.setText(_translate("MainWindow", "COM port"))
        self.label_2.setText(_translate("MainWindow", "RSSI at 1m"))
        self.groupBox_3.setTitle(_translate("MainWindow", "ANCHOR2"))
        self.groupBox_5.setTitle(_translate("MainWindow", "coordinate"))
        self.label_X2.setText(_translate("MainWindow", "X2"))
        self.label_Y2.setText(_translate("MainWindow", "Y2"))
        self.label_3.setText(_translate("MainWindow", "COM port"))
        self.label_4.setText(_translate("MainWindow", "RSSI at 1m"))
        self.groupBox_6.setTitle(_translate("MainWindow", "ANCHOR3"))
        self.groupBox_7.setTitle(_translate("MainWindow", "coordinate"))
        self.label_X3.setText(_translate("MainWindow", "X3"))
        self.label_Y3.setText(_translate("MainWindow", "Y3"))
        self.label_5.setText(_translate("MainWindow", "COM port"))
        self.label_6.setText(_translate("MainWindow", "RSSI at 1m"))
        self.groupBox_8.setTitle(_translate("MainWindow", "ANCHOR4"))
        self.groupBox_9.setTitle(_translate("MainWindow", "coordinate"))
        self.label_X4.setText(_translate("MainWindow", "X4"))
        self.label_Y4.setText(_translate("MainWindow", "Y4"))
        self.label_7.setText(_translate("MainWindow", "COM port"))
        self.label_8.setText(_translate("MainWindow", "RSSI at 1m"))
        self.label.setText(_translate("MainWindow", "Radio attenuation factor"))
        self.startButton.setText(_translate("MainWindow", "Start"))
        self.ExitButton.setText(_translate("MainWindow", "Exit"))
        self.checkBox.setText(_translate("MainWindow", "RSSI Filter on PC"))
        self.groupBox_8.setEnabled(False)
        self.init_widget_setting()

    # Scan all serial ports and add serial port num to comboBox
    def serial_port_scan(self):
        self.tbOutText = QPlainTextEdit()
        # Scan all serial ports
        portlist = list(serial.tools.list_ports.comports())
        if len(portlist) <= 0:
            print("The Serial port can't find!")
            self.tbOutText.appendPlainText("The Serial port can't find!")
        else:
            # get serial port num
            for i in range(len(portlist)):
                portlist_str.append(portlist[i][0])
        # add port num string to comboBox
        self.comboBox_anchor1.addItems(portlist_str)
        self.comboBox_anchor2.addItems(portlist_str)
        self.comboBox_anchor3.addItems(portlist_str)
        # self.comboBox_anchor4.addItems(portlist_str)

    # Collect anchro info and store to anchor_list, if any widget in group is null
    # then the anchor is invalid
    def collect_valid_anchor_info(self):
        # global myanchor1, myanchor2, myanchor3, myanchor4
        is_com_port_same = False
        attenuation = float(self.lineEdit_attenuation.text())
        # Anchor 1 info
        myanchor1 = anchor_common.AnchorInfo()
        myanchor1.anchro_name = 'Anchor1'
        myanchor1.comport = self.comboBox_anchor1.currentText()
        myanchor1.x = self.lineEdit_X1.text()
        myanchor1.y = self.lineEdit_Y1.text()
        myanchor1.rssi_value_at_one_meter = self.lineEdit_5.text()
        myanchor1.attenuation = attenuation
        if myanchor1.Is_valid_Info():
            addtolist = True
            for i in range(len(list_myanchors)):
                if list_myanchors[i].anchro_name != myanchor1.anchro_name:
                    if list_myanchors[i].comport == myanchor1.comport:
                        is_com_port_same = True
                        addtolist = False
                else:
                    # Update
                    list_myanchors[i] = myanchor1
            if addtolist is True:
                list_myanchors.append(myanchor1)
        # Anchor 2 info
        myanchor2 = anchor_common.AnchorInfo()
        myanchor2.anchro_name = 'Anchor2'
        myanchor2.comport = self.comboBox_anchor2.currentText()
        myanchor2.x = self.lineEdit_X2.text()
        myanchor2.y = self.lineEdit_Y2.text()
        myanchor2.rssi_value_at_one_meter = self.lineEdit_8.text()
        myanchor2.attenuation = attenuation
        if myanchor2.Is_valid_Info():
            addtolist = True
            for i in range(len(list_myanchors)):
                if list_myanchors[i].anchro_name != myanchor2.anchro_name:
                    if list_myanchors[i].comport == myanchor2.comport:
                        is_com_port_same = True
                        addtolist = False
                else:
                    # Update list
                    list_myanchors[i] = myanchor2
            if addtolist is True:
                list_myanchors.append(myanchor2)
        # Anchor 3 info
        myanchor3 = anchor_common.AnchorInfo()
        myanchor3.anchro_name = 'Anchor3'
        myanchor3.comport = self.comboBox_anchor3.currentText()
        myanchor3.x = self.lineEdit_X3.text()
        myanchor3.y = self.lineEdit_Y3.text()
        myanchor3.rssi_value_at_one_meter = self.lineEdit_11.text()
        myanchor3.attenuation = attenuation
        if myanchor3.Is_valid_Info():
            addtolist = True
            for i in range(len(list_myanchors)):
                if list_myanchors[i].anchro_name != myanchor3.anchro_name:
                    if list_myanchors[i].comport == myanchor3.comport:
                        is_com_port_same = True
                        addtolist = False
                else:
                    # Update list
                    list_myanchors[i] = myanchor3
            if addtolist is True:
                list_myanchors.append(myanchor3)
        # Anchor 4 info
        myanchor4 = anchor_common.AnchorInfo()
        myanchor4.anchro_name = 'Anchor4'
        myanchor4.comport = self.comboBox_anchor4.currentText()
        myanchor4.x = self.lineEdit_X4.text()
        myanchor4.y = self.lineEdit_Y4.text()
        myanchor4.rssi_value_at_one_meter = self.lineEdit_14.text()
        myanchor4.attenuation = attenuation
        if myanchor4.Is_valid_Info():
            addtolist = True
            for i in range(len(list_myanchors)):
                if list_myanchors[i].anchro_name != myanchor4.anchro_name:
                    if list_myanchors[i].comport == myanchor4.comport:
                        is_com_port_same = True
                        addtolist = False
                else:
                    # Update list
                    list_myanchors[i] = myanchor4
            if addtolist is True:
                list_myanchors.append(myanchor4)
        if is_com_port_same is True:
            QMessageBox.warning(self.centralwidget, 'Warning', "Serial port cannot be the same", QMessageBox.Ok)

    # Scan all serial ports and add serial port num to comboBox
    def collect_and_display_thread_run(self):
        global first_get_location
        global my_queue
        global list_myanchors

        self._thread_running = True
        first_get_location = True
        for i in range(len(list_myanchors)):
            dict_l = {list_myanchors[i].anchro_name: 0}

        while self._thread_running is True:
            # The datas in queue are from com port, so readout data if there are valid data in queue
            if not my_queue.empty():
                rssi_value = my_queue.get(block=False)
                print(rssi_value, file=my_output_file)
                assert isinstance(rssi_value, str)
                for i in range(len(list_myanchors)):
                    # calculate distance and store it
                    if list_myanchors[i].anchro_name == rssi_value.split(':')[0]:
                        dis_value = CalcPosition.RSSI_DistanceCalc(float(rssi_value.split(':')[1]),
                                                                   list_myanchors[i].rssi_value_at_one_meter,
                                                                   list_myanchors[i].attenuation)
                        # meter to millimeter
                        if dis_value is not "nan":
                            list_myanchors[i].distance = dis_value * 1000
                        print(list_myanchors[i].anchro_name + " dis is: " + str(dis_value), file=my_output_file)

            # Judge whether all distance value are calculated or not
            collected_all_anchor_distance = True
            for i in range(len(list_myanchors)):
                if list_myanchors[i].distance == 0:
                    collected_all_anchor_distance = False
            if collected_all_anchor_distance is True:
                print("start", file=my_output_file)
                [unknowx, unknowy] = CalcPosition.triposition1(list_myanchors[0].x, list_myanchors[0].y, list_myanchors[0].distance,
                                                               list_myanchors[1].x, list_myanchors[1].y, list_myanchors[1].distance,
                                                               list_myanchors[2].x, list_myanchors[2].y, list_myanchors[2].distance)
                print("x is ", unknowx, file=my_output_file)
                print("y is ", unknowy, file=my_output_file)
                if first_get_location is True:
                    first_get_location = False
                else:
                    # get last point handler
                    # aaa = fig_ax1.plot(locx, locy, 'r*', color='g')
                    # clear point in figure
                    # fig1_ax0.lines.remove(aaa[0])
                    del aaa
                # Just for conversion ratio, now the conversion ratio is set to 1
                [locx, locy] = [unknowx / 1, unknowy / 1]
                # Show point
                aaa = fig_ax1.plot(locx, locy, 'r*', color='g', linestyle='dashed', linewidth=2)

                # clean dictionary content
                for i in range(len(list_myanchors)):
                    list_myanchors[i].distance = 0
        # Close log file when thread stop
        my_output_file.close()

    # Save the widget setting to ini file
    def save_widget_setting(self):
        settings = QSettings("config.ini", QSettings.IniFormat)
        settings.setValue("attenuation", self.lineEdit_attenuation.text())
        settings.setValue("X1", self.lineEdit_X1.text())
        settings.setValue("Y1", self.lineEdit_Y1.text())
        settings.setValue("anchor1 Rssi value at 1m", self.lineEdit_5.text())
        settings.setValue("X2", self.lineEdit_X2.text())
        settings.setValue("Y2", self.lineEdit_Y2.text())
        settings.setValue("anchor2 Rssi value at 1m", self.lineEdit_8.text())
        settings.setValue("X3", self.lineEdit_X3.text())
        settings.setValue("Y3", self.lineEdit_Y3.text())
        settings.setValue("anchor3 Rssi value at 1m", self.lineEdit_11.text())
        settings.setValue("X4", self.lineEdit_X4.text())
        settings.setValue("Y4", self.lineEdit_Y4.text())
        settings.setValue("anchor4 Rssi value at 1m", self.lineEdit_14.text())
        settings.setValue("Filter on PC", self.checkBox.isChecked())

    # Init the widget setting
    def init_widget_setting(self):
        settings = QSettings("config.ini", QSettings.IniFormat)
        init_attenuation = settings.value("attenuation")
        self.lineEdit_attenuation.setText(init_attenuation)
        init_X1 = settings.value("X1")
        init_Y1 = settings.value("Y1")
        init_A1_Rssi_1m = settings.value("anchor1 Rssi value at 1m")
        self.lineEdit_X1.setText(init_X1)
        self.lineEdit_Y1.setText(init_Y1)
        self.lineEdit_5.setText(init_A1_Rssi_1m)
        init_X2 = settings.value("X2")
        init_Y2 = settings.value("Y2")
        init_A2_Rssi_1m = settings.value("anchor2 Rssi value at 1m")
        self.lineEdit_X2.setText(init_X2)
        self.lineEdit_Y2.setText(init_Y2)
        self.lineEdit_8.setText(init_A2_Rssi_1m)
        init_X3 = settings.value("X3")
        init_Y3 = settings.value("Y3")
        init_A3_Rssi_1m = settings.value("anchor3 Rssi value at 1m")
        self.lineEdit_X3.setText(init_X3)
        self.lineEdit_Y3.setText(init_Y3)
        self.lineEdit_11.setText(init_A3_Rssi_1m)
        init_X4 = settings.value("X4")
        init_Y4 = settings.value("Y4")
        init_A4_Rssi_1m = settings.value("anchor4 Rssi value at 1m")
        self.lineEdit_X4.setText(init_X4)
        self.lineEdit_Y4.setText(init_Y4)
        self.lineEdit_14.setText(init_A4_Rssi_1m)
        init_filter_on_pc = settings.value("Filter on PC")
        if init_filter_on_pc == "true" or init_filter_on_pc is True:
            self.checkBox.setChecked(True)

    # Create a txt file to store the test data, the file name is rssi_log.txt
    # Note:  my_output_file.close() must be called in somewhere so that data can be stored
    def text_create_open(self):
        global my_output_file
        # my_path = sys.path[0]
        # my_full_path = my_path + "\\"+ "rssi_log.txt"
        my_output = sys.stdout
        my_output_file = open('rssi_log.txt', 'w')
        sys.stdout = my_output_file

    #
    def terminate_thread(self):
        self._thread_running = False
    # # # slot function
    def slot_refresh_combo_box1(self):
        #sender = self.centralwidget.sender()
        self.comboBox_anchor1.clear()
        portlist_str = []
        portlist = list(serial.tools.list_ports.comports())
        if len(portlist) <= 0:
            print("The Serial port can't find!")
            self.tbOutText.appendPlainText("The Serial port can't find!")
        else:
            for i in range(len(portlist)):
                portlist_str.append(portlist[i][0])
        self.comboBox_anchor1.addItems(portlist_str)

    def slot_refresh_combo_box2(self):
        # sender = self.sender()
        self.comboBox_anchor2.clear()
        portlist_str = []
        portlist = list(serial.tools.list_ports.comports())
        if len(portlist) <= 0:
            print("The Serial port can't find!")
            self.tbOutText.appendPlainText("The Serial port can't find!")
        else:
            for i in range(len(portlist)):
                portlist_str.append(portlist[i][0])
        self.comboBox_anchor2.addItems(portlist_str)

    def slot_refresh_combo_box3(self):
        # sender = self.sender()
        self.comboBox_anchor3.clear()
        portlist_str = []
        portlist = list(serial.tools.list_ports.comports())
        if len(portlist) <= 0:
            print("The Serial port can't find!")
            self.tbOutText.appendPlainText("The Serial port can't find!")
        else:
            for i in range(len(portlist)):
                portlist_str.append(portlist[i][0])
        self.comboBox_anchor3.addItems(portlist_str)

    def slot_refresh_combo_box4(self):
        # sender = self.sender()
        self.comboBox_anchor4.clear()
        portlist_str = []
        portlist = list(serial.tools.list_ports.comports())
        if len(portlist) <= 0:
            print("The Serial port can't find!")
            self.tbOutText.appendPlainText("The Serial port can't find!")
        else:
            for i in range(len(portlist)):
                portlist_str.append(portlist[i][0])
        self.comboBox_anchor4.addItems(portlist_str)

    def slot_start_stop_localization(self):
        global fig_ax1
        global my_queue
        global local_t
        global figure
        _translate = QtCore.QCoreApplication.translate
        # Start buttun pushed
        self.save_widget_setting()
        if self.isLocatingStart is False:
            self.text_create_open()
            self.collect_valid_anchor_info()
            if len(list_myanchors) < 3:
                # The valid anchor less than 3, so cannot perform localization
                QMessageBox.warning(self.centralwidget,
                                    'Warning',
                                    "At least 3 anchor can perform localization!",
                                    QMessageBox.Ok)
                list_myanchors.clear()
                self.isLocatingStart = False
            else:
                # Disable all GroupBox, user should not modify it during performing localization
                self.groupBox.setEnabled(False)
                self.groupBox_3.setEnabled(False)
                self.groupBox_6.setEnabled(False)
                self.groupBox_8.setEnabled(False)

                # Clear all axes, place the anchor point on the figure, open com port
                fig_ax1.cla()
                for i in range(len(list_myanchors)):
                    fig_ax1.plot(list_myanchors[i].x, list_myanchors[i].y, 'k^', color='r')
                    # set com port read/write processing thread
                    ser_temp1 = serial_rw.MySerialPort(list_myanchors[i].comport, baudRate)
                    ser.append(ser_temp1)
                    t = threading.Thread(target=ser[i].SerialThread_Run,
                                         args=(my_queue, list_myanchors[i].anchro_name, self.checkBox.isChecked()))
                    t.daemon = True
                    thread1.append(t)

                # start all com port thread to collect com port data
                for thr in thread1:
                    time.sleep(0.1)
                    assert isinstance(thr, threading.Thread)
                    thr.start()

                # Start a thread to perform localization
                local_t = threading.Thread(target=self.collect_and_display_thread_run)
                local_t.daemon = True
                local_t.start()

                # Start a timer to trigger periodically
                # timer = QTimer(self.centralwidget)
                # timer.timeout.connect(self.slot_timer_refresh_figure)
                # timer.start(300)
                #
                self.startButton.setText(_translate("MainWindow", "Stop"))
                self.isLocatingStart = True
        # stop button pushed
        else:
            # stop the all threads
            for i in range(len(list_myanchors)):
                assert isinstance(ser[i], serial_rw.MySerialPort)
                ser[i].terminate_thread()
            for thr in thread1:
                assert isinstance(thr, threading.Thread)
                thr.join()
            self.terminate_thread()
            local_t.join()

            # clear all lists
            list_myanchors.clear()
            ser.clear()
            thread1.clear()
            my_queue.empty()

            # change the widget status
            self.isLocatingStart = False
            self.startButton.setText(_translate("MainWindow", "Start"))
            self.groupBox.setEnabled(True)
            self.groupBox_3.setEnabled(True)
            self.groupBox_6.setEnabled(True)
            # self.groupBox_8.setEnabled(True)
            # my_output_file.close()

    def slot_timer_refresh_figure(self):
        global testx, testy
        # testx += 1
        # testy += 1
        # fig_ax1.plot(testx, testy, 'r*', color='b', linestyle='dashed', linewidth=2)
    # # #

class CustomComboBox(QComboBox):
    popupAboutToBeShown = pyqtSignal()
    def showPopup(self):
        self.popupAboutToBeShown.emit()
        super(CustomComboBox, self).showPopup()

if __name__ == '__main__':
    testapp = QApplication(sys.argv)
    testDlg = QMainWindow()
    main_window_ui = RSSI_Test_MainWindow()
    main_window_ui.setupUi(testDlg)
    testDlg.setWindowTitle("NXP RSSI localization")
    testDlg.setMinimumSize(1000, 875)
    testDlg.showMaximized()
    sys.exit(testapp.exec_())
